/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.recovery.AutorecoveringConnection;
import com.rabbitmq.perf.Recovery;
import com.rabbitmq.perf.TopologyRecording;
import java.io.IOException;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AgentBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentBase.class);

    protected void delay(long now, AgentState state) {
        long elapsed = now - state.getLastStatsTime();
        float rateLimit = state.getRateLimit();
        long pause = (long)(rateLimit <= 0.0f ? 0.0 : (double)state.getMsgCount() * 1000.0 / (double)rateLimit - (double)elapsed);
        if (pause > 0L) {
            try {
                Thread.sleep(pause);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }

    protected boolean isConnectionRecoveryTriggered(ShutdownSignalException e) {
        return AutorecoveringConnection.DEFAULT_CONNECTION_RECOVERY_TRIGGERING_CONDITION.test(e);
    }

    protected void handleShutdownSignalExceptionOnWrite(Recovery.RecoveryProcess recoveryProcess, ShutdownSignalException e) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Handling write error, recovery process enabled? {}, condition to trigger connection recovery? {}", (Object)recoveryProcess.isEnabled(), (Object)this.isConnectionRecoveryTriggered(e));
        }
        if (this.shouldStop(recoveryProcess, e)) {
            throw e;
        }
    }

    protected boolean shouldStop(Recovery.RecoveryProcess recoveryProcess, ShutdownSignalException e) {
        if (recoveryProcess.isEnabled()) {
            return !this.isConnectionRecoveryTriggered(e);
        }
        return true;
    }

    protected void dealWithWriteOperation(WriteOperation writeOperation, Recovery.RecoveryProcess recoveryProcess) throws IOException {
        try {
            writeOperation.call();
        }
        catch (ShutdownSignalException e) {
            this.handleShutdownSignalExceptionOnWrite(recoveryProcess, e);
        }
        catch (SocketException e) {
            if (recoveryProcess.isEnabled()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Socket exception in write, recovery process is enabled, ignoring to let connection recovery carry on");
                }
            }
            throw e;
        }
    }

    public abstract void recover(TopologyRecording var1);

    @FunctionalInterface
    static interface WriteOperation {
        public void call() throws IOException;
    }

    protected static interface AgentState {
        public float getRateLimit();

        public long getLastStatsTime();

        public int getMsgCount();

        public int incrementMessageCount();
    }
}

