/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.MetricsCollector;
import com.rabbitmq.client.impl.MicrometerMetricsCollector;
import com.rabbitmq.perf.CommandLineProxy;
import com.rabbitmq.perf.Metrics;
import com.rabbitmq.perf.PerfTest;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.util.ArrayList;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class BaseMetrics
implements Metrics {
    @Override
    public Options options() {
        Options options = new Options();
        options.addOption(new Option("mt", "metrics-tags", true, "metrics tags as key-value pairs separated by commas"));
        options.addOption(new Option("mpx", "metrics-prefix", true, "prefix for PerfTest metrics, default is perftest_"));
        options.addOption(new Option("mc", "metrics-client", false, "enable client metrics"));
        options.addOption(new Option("mcl", "metrics-class-loader", false, "enable JVM class loader metrics"));
        options.addOption(new Option("mjm", "metrics-jvm-memory", false, "enable JVM memory metrics"));
        options.addOption(new Option("mjgc", "metrics-jvm-gc", false, "enable JVM GC metrics"));
        options.addOption(new Option("mjp", "metrics-processor", false, "enable processor metrics (gathered by JVM)"));
        options.addOption(new Option("mjt", "metrics-jvm-thread", false, "enable JVM thread metrics"));
        return options;
    }

    @Override
    public void configure(CommandLineProxy cmd, CompositeMeterRegistry meterRegistry, ConnectionFactory factory) {
        String argumentTags = PerfTest.strArg(cmd, "mt", null);
        ArrayList<Tag> tags = new ArrayList<Tag>();
        if (argumentTags != null) {
            for (String tag : argumentTags.split(",")) {
                String[] keyValue = tag.split("=");
                tags.add(Tag.of((String)keyValue[0], (String)keyValue[1]));
            }
        }
        meterRegistry.config().commonTags(tags);
        if (cmd.hasOption("mc")) {
            factory.setMetricsCollector((MetricsCollector)new MicrometerMetricsCollector((MeterRegistry)meterRegistry, "client"));
        }
        if (cmd.hasOption("mcl")) {
            new ClassLoaderMetrics().bindTo((MeterRegistry)meterRegistry);
        }
        if (cmd.hasOption("mjm")) {
            new JvmMemoryMetrics().bindTo((MeterRegistry)meterRegistry);
        }
        if (cmd.hasOption("mjgc")) {
            new JvmGcMetrics().bindTo((MeterRegistry)meterRegistry);
        }
        if (cmd.hasOption("mjp")) {
            new ProcessorMetrics().bindTo((MeterRegistry)meterRegistry);
        }
        if (cmd.hasOption("mjt")) {
            new JvmThreadMetrics().bindTo((MeterRegistry)meterRegistry);
        }
    }

    public String toString() {
        return "Base Metrics";
    }
}

