/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.tools.Host;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class Broker {
    private static final String BASE = "/tmp/rabbitmq-performance/";
    private static final String SCRIPTS = "../rabbitmq-server/scripts/";
    private static final String HIPE_C = "{rabbit, [{hipe_compile, true}]}";
    private static final String COARSE_C = "{rabbitmq_management_agent, [{force_fine_statistics, false}]}";
    private final String name;
    private final String config;

    public Broker(String name) {
        this(name, "[].");
    }

    public Broker(String name, String config) {
        this.name = name;
        this.config = config;
    }

    public void start() throws IOException {
        Process pr = null;
        try {
            this.writeConfig();
            System.out.println("Starting broker '" + this.name + "'...");
            ProcessBuilder pb = new ProcessBuilder("../rabbitmq-server/scripts/rabbitmq-server");
            pb.environment().put("RABBITMQ_PID_FILE", this.pidfile());
            pb.environment().put("RABBITMQ_LOG_BASE", "/tmp/rabbitmq-performance/logs");
            pb.environment().put("RABBITMQ_MNESIA_DIR", "/tmp/rabbitmq-performance/db");
            pb.environment().put("RABBITMQ_PLUGINS_EXPAND_DIR", "/tmp/rabbitmq-performance/plugins-expand");
            pb.environment().put("RABBITMQ_CONFIG_FILE", "/tmp/rabbitmq-performance/rabbitmq");
            pr = pb.start();
            Host.executeCommand("../rabbitmq-server/scripts/rabbitmqctl wait " + this.pidfile());
        }
        catch (IOException e) {
            System.out.println("Broker start failed!");
            assert (pr != null);
            String stdout = Broker.capture(pr.getInputStream());
            String stderr = Broker.capture(pr.getErrorStream());
            System.out.println(stdout);
            System.out.println(stderr);
            throw new RuntimeException(e);
        }
    }

    private String pidfile() {
        return "/tmp/rabbitmq-performance/pid";
    }

    private void writeConfig() throws IOException {
        new File(BASE).mkdirs();
        try (PrintWriter out = new PrintWriter(new FileWriter("/tmp/rabbitmq-performance/rabbitmq.config"));){
            out.println(this.config);
        }
    }

    public void stop() {
        System.out.println("Stopping broker '" + this.name + "' ...");
        try {
            Host.executeCommand("../rabbitmq-server/scripts/rabbitmqctl stop " + this.pidfile());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    private static String capture(InputStream is) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder buff = new StringBuilder();
        while ((line = br.readLine()) != null) {
            buff.append(line);
        }
        return buff.toString();
    }
}

