/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.perf.BaseMetrics;
import com.rabbitmq.perf.CommandLineProxy;
import com.rabbitmq.perf.DatadogMetrics;
import com.rabbitmq.perf.JmxMetrics;
import com.rabbitmq.perf.Metrics;
import com.rabbitmq.perf.OptionsUtils;
import com.rabbitmq.perf.PrometheusMetrics;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeMetrics
implements Metrics {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeMetrics.class);
    private final List<Metrics> metrics = new ArrayList<Metrics>();

    public CompositeMetrics() {
        this.metrics.add(new BaseMetrics());
        this.metrics.add(new PrometheusMetrics());
        this.metrics.add(new DatadogMetrics());
        this.metrics.add(new JmxMetrics());
    }

    @Override
    public Options options() {
        Options options = new Options();
        for (Metrics metric : this.metrics) {
            OptionsUtils.forEach(metric.options(), option -> {
                if (options.hasOption(option.getOpt())) {
                    throw new IllegalStateException("Option already existing: " + option.getOpt());
                }
                options.addOption(option);
            });
        }
        return options;
    }

    @Override
    public void configure(CommandLineProxy cmd, CompositeMeterRegistry meterRegistry, ConnectionFactory factory) throws Exception {
        for (Metrics metric : this.metrics) {
            metric.configure(cmd, meterRegistry, factory);
        }
    }

    @Override
    public boolean isEnabled(CommandLineProxy cmd) {
        for (Metrics metric : this.metrics) {
            if (!metric.isEnabled(cmd)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        for (Metrics metric : this.metrics) {
            try {
                metric.close();
            }
            catch (Exception e) {
                LOGGER.warn("Error while closing metrics {}", this.metrics, (Object)e);
            }
        }
    }
}

