/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.perf.MessageBodySource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LocalFilesMessageBodySource
implements MessageBodySource {
    private final long ZERO = 0L;
    private final List<byte[]> bodies;
    private final String contentType;

    public LocalFilesMessageBodySource(List<String> filesNames, String contentType) throws IOException {
        this.bodies = new ArrayList<byte[]>(filesNames.size());
        for (String fileName : filesNames) {
            File file = new File(fileName.trim());
            if (!file.exists() || file.isDirectory()) {
                throw new IllegalArgumentException(fileName + " isn't a valid body file.");
            }
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
            Throwable throwable = null;
            try {
                byte[] body = new byte[(int)file.length()];
                inputStream.read(body, 0, body.length);
                this.bodies.add(body);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
        this.contentType = contentType;
    }

    public LocalFilesMessageBodySource(List<String> filesNames) throws IOException {
        this(filesNames, null);
    }

    @Override
    public MessageBodySource.MessageEnvelope create(int sequenceNumber) {
        return new MessageBodySource.MessageEnvelope(this.bodies.get(sequenceNumber % this.bodies.size()), this.contentType, 0L);
    }
}

