/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Recoverable;
import com.rabbitmq.client.RecoveryListener;
import com.rabbitmq.client.impl.recovery.AutorecoveringConnection;
import com.rabbitmq.perf.FixedValueIndicator;
import com.rabbitmq.perf.MulticastParams;
import com.rabbitmq.perf.NamedThreadFactory;
import com.rabbitmq.perf.Producer;
import com.rabbitmq.perf.ShutdownService;
import com.rabbitmq.perf.Stats;
import com.rabbitmq.perf.Utils;
import com.rabbitmq.perf.ValueIndicator;
import com.rabbitmq.perf.VariableValueIndicator;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MulticastSet {
    public static final int DEFAULT_CONSUMER_WORK_SERVICE_THREAD_POOL_SIZE = Runtime.getRuntime().availableProcessors() * 2;
    private static final Logger LOGGER = LoggerFactory.getLogger(MulticastSet.class);
    private static final int PUBLISHING_INTERVAL_NB_PRODUCERS_PER_THREAD = 50;
    private static final String PRODUCER_THREAD_PREFIX = "perf-test-producer-";
    private final Stats stats;
    private final ConnectionFactory factory;
    private final MulticastParams params;
    private final String testID;
    private final List<String> uris;
    private final Random random = new Random();
    private final CompletionHandler completionHandler;
    private final ShutdownService shutdownService;
    private ThreadingHandler threadingHandler = new DefaultThreadingHandler();
    private final ValueIndicator<Float> rateIndicator;
    private final ValueIndicator<Integer> messageSizeIndicator;

    public MulticastSet(Stats stats, ConnectionFactory factory, MulticastParams params, List<String> uris, CompletionHandler completionHandler) {
        this(stats, factory, params, "perftest", uris, completionHandler, new ShutdownService());
    }

    public MulticastSet(Stats stats, ConnectionFactory factory, MulticastParams params, String testID, List<String> uris, CompletionHandler completionHandler) {
        this(stats, factory, params, testID, uris, completionHandler, new ShutdownService());
    }

    public MulticastSet(Stats stats, ConnectionFactory factory, MulticastParams params, String testID, List<String> uris, CompletionHandler completionHandler, ShutdownService shutdownService) {
        ScheduledExecutorService scheduledExecutorService;
        this.stats = stats;
        this.factory = factory;
        this.params = params;
        this.testID = testID;
        this.uris = uris == null || uris.isEmpty() ? null : new CopyOnWriteArrayList<String>(uris);
        this.completionHandler = completionHandler;
        this.shutdownService = shutdownService;
        this.params.init();
        if (this.params.getPublishingRates() == null || this.params.getPublishingRates().isEmpty()) {
            this.rateIndicator = new FixedValueIndicator<Float>(Float.valueOf(params.getProducerRateLimit()));
        } else {
            scheduledExecutorService = this.threadingHandler.scheduledExecutorService("perf-test-variable-rate-scheduler", 1);
            this.rateIndicator = new VariableValueIndicator<Float>(params.getPublishingRates(), scheduledExecutorService, input -> Float.valueOf(input));
        }
        if (this.params.getMessageSizes() == null || this.params.getMessageSizes().isEmpty()) {
            this.messageSizeIndicator = new FixedValueIndicator<Integer>(params.getMinMsgSize());
        } else {
            scheduledExecutorService = this.threadingHandler.scheduledExecutorService("perf-test-variable-message-size-scheduler", 1);
            this.messageSizeIndicator = new VariableValueIndicator<Integer>(params.getMessageSizes(), scheduledExecutorService, input -> Integer.valueOf(input));
        }
    }

    protected static int nbThreadsForConsumer(MulticastParams params) {
        return Math.min(params.getConsumerChannelCount(), DEFAULT_CONSUMER_WORK_SERVICE_THREAD_POOL_SIZE);
    }

    protected static int nbThreadsForProducerScheduledExecutorService(MulticastParams params) {
        int producerExecutorServiceNbThreads = params.getProducerSchedulerThreadCount();
        if (producerExecutorServiceNbThreads <= 0) {
            return params.getProducerThreadCount() / 50 + 1;
        }
        return producerExecutorServiceNbThreads;
    }

    public void run() throws IOException, InterruptedException, TimeoutException, NoSuchAlgorithmException, KeyManagementException, URISyntaxException, ExecutionException {
        this.run(false);
    }

    public void run(boolean announceStartup) throws IOException, InterruptedException, TimeoutException, NoSuchAlgorithmException, KeyManagementException, URISyntaxException {
        int n = this.params.getServersStartUpTimeout();
        int n2 = this.params.getServersUpLimit() == -1 ? (this.uris == null ? 0 : this.uris.size()) : this.params.getServersUpLimit();
        if (MulticastSet.waitUntilBrokerAvailableIfNecessary(n, n2, this.uris, this.factory)) {
            ScheduledExecutorService heartbeatSenderExecutorService = this.threadingHandler.scheduledExecutorService("perf-test-heartbeat-sender-", this.params.getHeartbeatSenderThreads());
            this.factory.setHeartbeatExecutor(heartbeatSenderExecutorService);
            this.setUri();
            Connection configurationConnection = this.factory.newConnection("perf-test-configuration");
            MulticastParams.TopologyHandlerResult topologyHandlerResult = this.params.configureAllQueues(configurationConnection);
            this.enableTopologyRecoveryIfNecessary(configurationConnection, topologyHandlerResult);
            this.params.resetTopologyHandler();
            Runnable[] consumerRunnables = new Runnable[this.params.getConsumerThreadCount()];
            Connection[] consumerConnections = new Connection[this.params.getConsumerCount()];
            Function<Integer, ExecutorService> consumersExecutorsFactory = this.createConsumersExecutorsFactory();
            this.createConsumers(announceStartup, consumerRunnables, consumerConnections, consumersExecutorsFactory);
            this.params.resetTopologyHandler();
            AgentState[] producerStates = new AgentState[this.params.getProducerThreadCount()];
            Connection[] producerConnections = new Connection[this.params.getProducerCount()];
            ExecutorService executorServiceForProducersConsumers = this.threadingHandler.executorService("perf-test-producers-worker-", 0);
            this.factory.setSharedExecutor(executorServiceForProducersConsumers);
            this.createProducers(announceStartup, producerStates, producerConnections);
            this.startConsumers(consumerRunnables);
            this.startProducers(producerStates);
            int shutdownTimeout = this.params.getShutdownTimeout();
            AutoCloseable shutdownSequence = shutdownTimeout > 0 ? this.shutdownService.wrap(() -> {
                CountDownLatch latch = new CountDownLatch(1);
                Thread shutdownThread = new Thread(() -> {
                    if (this.params.isPolling()) {
                        Connection connection = null;
                        try {
                            connection = this.factory.newConnection("perf-test-queue-deletion");
                            this.params.deleteAutoDeleteQueuesIfNecessary(connection);
                        }
                        catch (Exception e) {
                            LOGGER.warn("Error while trying to delete auto-delete queues");
                        }
                        finally {
                            if (connection != null) {
                                MulticastSet.dispose(connection);
                            }
                        }
                    }
                    if (Thread.interrupted()) {
                        return;
                    }
                    try {
                        this.shutdown(configurationConnection, consumerConnections, producerStates, producerConnections);
                    }
                    finally {
                        latch.countDown();
                    }
                });
                shutdownThread.start();
                boolean done = latch.await(shutdownTimeout, TimeUnit.SECONDS);
                if (!done) {
                    LOGGER.debug("Shutdown not completed in {} second(s), aborting.", (Object)shutdownTimeout);
                    shutdownThread.interrupt();
                }
            }) : () -> {};
            this.completionHandler.waitForCompletion();
            try {
                shutdownSequence.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            System.out.println("Could not connect to broker(s) in " + this.params.getServersStartUpTimeout() + " second(s), exiting.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean waitUntilBrokerAvailableIfNecessary(int startUpTimeoutInSeconds, int serversUpLimit, Collection<String> uris, ConnectionFactory factory) throws NoSuchAlgorithmException, KeyManagementException, URISyntaxException, InterruptedException {
        if (startUpTimeoutInSeconds <= 0) return true;
        if (uris == null) return true;
        if (uris.isEmpty()) {
            return true;
        }
        ArrayList<String> tested = new ArrayList<String>(uris);
        ArrayList<String> connected = new ArrayList<String>();
        long started = System.nanoTime();
        while ((System.nanoTime() - started) / 1000000000L < (long)startUpTimeoutInSeconds) {
            Iterator iterator = tested.iterator();
            while (iterator.hasNext()) {
                String uri = (String)iterator.next();
                factory.setUri(uri);
                try {
                    Connection ignored = factory.newConnection("perf-test-test");
                    Throwable throwable = null;
                    try {
                        connected.add(uri);
                        if (connected.size() == serversUpLimit) {
                            uris.clear();
                            uris.addAll(connected);
                            boolean bl = true;
                            return bl;
                        }
                        iterator.remove();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ignored == null) continue;
                        if (throwable != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ignored.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.info("Could not connect to broker " + factory.getHost() + ":" + factory.getPort());
                }
            }
            Thread.sleep(1000L);
        }
        return false;
    }

    private Function<Integer, ExecutorService> createConsumersExecutorsFactory() {
        Function<Integer, ExecutorService> consumersExecutorsFactory = this.params.isPolling() ? consumerNumber -> this.threadingHandler.executorService(String.format("perf-test-synchronous-consumer-%d-worker-", consumerNumber), this.params.getConsumerChannelCount() + 1) : (this.params.getConsumersThreadPools() > 0 ? new CacheConsumersExecutorsFactory(this.threadingHandler, this.params, this.params.getConsumersThreadPools()) : new NoCacheConsumersExecutorsFactory(this.threadingHandler, this.params));
        return consumersExecutorsFactory;
    }

    private void createConsumers(boolean announceStartup, Runnable[] consumerRunnables, Connection[] consumerConnections, Function<Integer, ExecutorService> consumersExecutorsFactory) throws URISyntaxException, NoSuchAlgorithmException, KeyManagementException, IOException, TimeoutException {
        for (int i = 0; i < consumerConnections.length; ++i) {
            Connection consumerConnection;
            if (announceStartup) {
                System.out.println("id: " + this.testID + ", starting consumer #" + i);
            }
            this.setUri();
            ExecutorService executorService = consumersExecutorsFactory.apply(i);
            this.factory.setSharedExecutor(executorService);
            consumerConnections[i] = consumerConnection = this.factory.newConnection("perf-test-consumer-" + i);
            for (int j = 0; j < this.params.getConsumerChannelCount(); ++j) {
                if (announceStartup) {
                    System.out.println("id: " + this.testID + ", starting consumer #" + i + ", channel #" + j);
                }
                consumerRunnables[i * this.params.getConsumerChannelCount() + j] = this.params.createConsumer(consumerConnection, this.stats, this.completionHandler, executorService);
            }
        }
    }

    private void createProducers(boolean announceStartup, AgentState[] producerStates, Connection[] producerConnections) throws URISyntaxException, NoSuchAlgorithmException, KeyManagementException, IOException, TimeoutException {
        for (int i = 0; i < producerConnections.length; ++i) {
            Connection producerConnection;
            if (announceStartup) {
                System.out.println("id: " + this.testID + ", starting producer #" + i);
            }
            this.setUri();
            producerConnections[i] = producerConnection = this.factory.newConnection(PRODUCER_THREAD_PREFIX + i);
            for (int j = 0; j < this.params.getProducerChannelCount(); ++j) {
                if (announceStartup) {
                    System.out.println("id: " + this.testID + ", starting producer #" + i + ", channel #" + j);
                }
                AgentState agentState = new AgentState();
                agentState.runnable = this.params.createProducer(producerConnection, this.stats, this.completionHandler, this.rateIndicator, this.messageSizeIndicator);
                producerStates[i * this.params.getProducerChannelCount() + j] = agentState;
            }
        }
    }

    private void startConsumers(Runnable[] consumerRunnables) throws InterruptedException {
        for (Runnable runnable : consumerRunnables) {
            runnable.run();
            if (!this.params.getConsumerSlowStart()) continue;
            System.out.println("Delaying start by 1 second because -S/--slow-start was requested");
            Thread.sleep(1000L);
        }
    }

    private void startProducers(AgentState[] producerStates) {
        this.messageSizeIndicator.start();
        if (this.params.getPublishingInterval() > 0) {
            Supplier<Integer> startDelaySupplier;
            ScheduledExecutorService producersExecutorService = this.threadingHandler.scheduledExecutorService(PRODUCER_THREAD_PREFIX, MulticastSet.nbThreadsForConsumer(this.params));
            if (this.params.getProducerRandomStartDelayInSeconds() > 0) {
                Random random = new Random();
                startDelaySupplier = () -> random.nextInt(this.params.getProducerRandomStartDelayInSeconds()) + 1;
            } else {
                startDelaySupplier = () -> 0;
            }
            int publishingInterval = this.params.getPublishingInterval();
            for (int i = 0; i < producerStates.length; ++i) {
                AgentState producerState = producerStates[i];
                int delay = startDelaySupplier.get();
                producerState.task = producersExecutorService.scheduleAtFixedRate(producerState.runnable.createRunnableForScheduling(), delay, publishingInterval, TimeUnit.SECONDS);
            }
        } else {
            this.rateIndicator.start();
            ExecutorService producersExecutorService = this.threadingHandler.executorService(PRODUCER_THREAD_PREFIX, producerStates.length);
            for (AgentState producerState : producerStates) {
                producerState.task = producersExecutorService.submit(producerState.runnable);
            }
        }
    }

    private void shutdown(Connection configurationConnection, Connection[] consumerConnections, AgentState[] producerStates, Connection[] producerConnections) {
        try {
            LOGGER.debug("Starting test shutdown");
            for (AgentState agentState : producerStates) {
                if (Thread.interrupted()) {
                    return;
                }
                boolean cancelled = agentState.task.cancel(true);
                LOGGER.debug("Producer has been correctly cancelled: {}", (Object)cancelled);
            }
            for (AgentState agentState : producerStates) {
                if (agentState.task.isDone()) continue;
                try {
                    if (Thread.interrupted()) {
                        return;
                    }
                    agentState.task.get(10L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    LOGGER.debug("Error while waiting for producer to stop: {}. Moving on.", (Object)e.getMessage());
                }
            }
            if (Thread.interrupted()) {
                return;
            }
            MulticastSet.dispose(configurationConnection);
            for (AgentState agentState : producerConnections) {
                if (Thread.interrupted()) {
                    return;
                }
                MulticastSet.dispose((Connection)agentState);
            }
            for (AgentState agentState : consumerConnections) {
                if (Thread.interrupted()) {
                    return;
                }
                MulticastSet.dispose((Connection)agentState);
            }
            if (Thread.interrupted()) {
                return;
            }
            LOGGER.debug("Shutting down threading handler");
            this.threadingHandler.shutdown();
            LOGGER.debug("Threading handler shut down");
        }
        catch (Exception e) {
            LOGGER.warn("Error during test shutdown", (Throwable)e);
        }
    }

    private void enableTopologyRecoveryIfNecessary(Connection configurationConnection, final MulticastParams.TopologyHandlerResult topologyHandlerResult) throws IOException {
        if (Utils.isRecoverable(topologyHandlerResult.connection)) {
            final Connection connection = topologyHandlerResult.connection;
            final String connectionName = connection.getClientProvidedName();
            ((AutorecoveringConnection)connection).addRecoveryListener(new RecoveryListener(){

                public void handleRecoveryStarted(Recoverable recoverable) {
                    LOGGER.debug("Connection recovery started for connection {}", (Object)connectionName);
                }

                public void handleRecovery(Recoverable recoverable) {
                    LOGGER.debug("Starting topology recovery for connection {}", (Object)connectionName);
                    topologyHandlerResult.topologyRecording.recover(connection);
                    LOGGER.debug("Topology recovery done for connection {}", (Object)connectionName);
                }
            });
        } else {
            configurationConnection.close();
        }
    }

    private static void dispose(Connection connection) {
        try {
            LOGGER.debug("Closing connection {}", (Object)connection.getClientProvidedName());
            connection.close(200, "Closed by PerfTest", 3000);
            LOGGER.debug("Connection {} has been closed", (Object)connection.getClientProvidedName());
        }
        catch (AlreadyClosedException e) {
            LOGGER.debug("Connection {} already closed", (Object)connection.getClientProvidedName());
        }
        catch (Exception e) {
            LOGGER.debug("Error while closing connection {}: {}", (Object)connection.getClientProvidedName(), (Object)e.getMessage());
        }
    }

    private void setUri() throws URISyntaxException, NoSuchAlgorithmException, KeyManagementException {
        if (this.uris != null && !this.uris.isEmpty()) {
            this.factory.setUri(this.uri());
        }
    }

    private String uri() {
        String uri = this.uris.get(this.random.nextInt(this.uris.size()));
        return uri;
    }

    public void setThreadingHandler(ThreadingHandler threadingHandler) {
        this.threadingHandler = threadingHandler;
    }

    static class CacheConsumersExecutorsFactory
    implements Function<Integer, ExecutorService> {
        private final ThreadingHandler threadingHandler;
        private final MulticastParams params;
        private final int modulo;
        private final List<ExecutorService> cache;

        CacheConsumersExecutorsFactory(ThreadingHandler threadingHandler, MulticastParams params, int modulo) {
            this.threadingHandler = threadingHandler;
            this.params = params;
            this.modulo = modulo;
            this.cache = new ArrayList<ExecutorService>(modulo);
            IntStream.range(0, modulo).forEach(i -> this.cache.add(null));
        }

        @Override
        public ExecutorService apply(Integer consumerNumber) {
            int remaining = consumerNumber % this.modulo;
            ExecutorService executorService = this.cache.get(remaining);
            if (executorService == null) {
                executorService = this.threadingHandler.executorService(String.format("perf-test-shared-consumer-worker-%d-", remaining), MulticastSet.nbThreadsForConsumer(this.params));
                this.cache.set(remaining, executorService);
            }
            return executorService;
        }
    }

    static class NoCacheConsumersExecutorsFactory
    implements Function<Integer, ExecutorService> {
        private final ThreadingHandler threadingHandler;
        private final MulticastParams params;

        NoCacheConsumersExecutorsFactory(ThreadingHandler threadingHandler, MulticastParams params) {
            this.threadingHandler = threadingHandler;
            this.params = params;
        }

        @Override
        public ExecutorService apply(Integer consumerNumber) {
            ExecutorService executorService = this.threadingHandler.executorService(String.format("perf-test-consumer-%d-worker-", consumerNumber), MulticastSet.nbThreadsForConsumer(this.params));
            return executorService;
        }
    }

    static class NoLimitCompletionHandler
    implements CompletionHandler {
        private final CountDownLatch latch = new CountDownLatch(1);

        NoLimitCompletionHandler() {
        }

        @Override
        public void waitForCompletion() throws InterruptedException {
            this.latch.await();
        }

        @Override
        public void countDown() {
            this.latch.countDown();
        }
    }

    static class DefaultCompletionHandler
    implements CompletionHandler {
        private final int timeLimit;
        private final CountDownLatch latch;

        DefaultCompletionHandler(int timeLimit, int countLimit) {
            this.timeLimit = timeLimit;
            this.latch = new CountDownLatch(countLimit <= 0 ? 1 : countLimit);
        }

        @Override
        public void waitForCompletion() throws InterruptedException {
            if (this.timeLimit <= 0) {
                this.latch.await();
            } else {
                boolean countedDown = this.latch.await(this.timeLimit, TimeUnit.SECONDS);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Completed, counted down? {}", (Object)countedDown);
                }
            }
        }

        @Override
        public void countDown() {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Counting down");
            }
            this.latch.countDown();
        }
    }

    private static class AgentState {
        private Producer runnable;
        private Future<?> task;

        private AgentState() {
        }
    }

    static class DefaultThreadingHandler
    implements ThreadingHandler {
        private final Collection<ExecutorService> executorServices = new ArrayList<ExecutorService>();
        private final AtomicBoolean closing = new AtomicBoolean(false);
        private final String prefix;

        DefaultThreadingHandler(String prefix) {
            this.prefix = prefix;
        }

        DefaultThreadingHandler() {
            this("");
        }

        @Override
        public ExecutorService executorService(String name, int nbThreads) {
            if (nbThreads <= 0) {
                return this.create(() -> Executors.newSingleThreadExecutor(new NamedThreadFactory(this.prefix + name)));
            }
            return this.create(() -> Executors.newFixedThreadPool(nbThreads, new NamedThreadFactory(this.prefix + name)));
        }

        @Override
        public ScheduledExecutorService scheduledExecutorService(String name, int nbThreads) {
            return (ScheduledExecutorService)this.create(() -> Executors.newScheduledThreadPool(nbThreads, new NamedThreadFactory(name)));
        }

        private ExecutorService create(Supplier<ExecutorService> s) {
            ExecutorService executorService = s.get();
            this.executorServices.add(executorService);
            return executorService;
        }

        @Override
        public void shutdown() {
            if (this.closing.compareAndSet(false, true)) {
                for (ExecutorService executorService : this.executorServices) {
                    executorService.shutdownNow();
                    try {
                        boolean terminated = executorService.awaitTermination(10L, TimeUnit.SECONDS);
                        if (terminated) continue;
                        LoggerFactory.getLogger(DefaultThreadingHandler.class).warn("Some PerfTest tasks (producer, consumer, rate scheduler) didn't finish");
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    public static interface CompletionHandler {
        public void waitForCompletion() throws InterruptedException;

        public void countDown();
    }

    static interface ThreadingHandler {
        public ExecutorService executorService(String var1, int var2);

        public ScheduledExecutorService scheduledExecutorService(String var1, int var2);

        public void shutdown();
    }
}

