/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.codahale.metrics.Histogram;
import com.rabbitmq.perf.Stats;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicBoolean;

class PrintlnStats
extends Stats {
    public static final String MESSAGE_RATE_LABEL = "msg/s";
    private final boolean sendStatsEnabled;
    private final boolean recvStatsEnabled;
    private final boolean returnStatsEnabled;
    private final boolean confirmStatsEnabled;
    private final boolean legacyMetrics;
    private final boolean useMillis;
    private final String units;
    private final String testID;
    private final PrintWriter csvOut;
    private final PrintStream out;
    private final AtomicBoolean printFinalOnGoingOrDone = new AtomicBoolean(false);

    public PrintlnStats(String testID, long interval, boolean sendStatsEnabled, boolean recvStatsEnabled, boolean returnStatsEnabled, boolean confirmStatsEnabled, boolean legacyMetrics, boolean useMillis, PrintWriter csvOut, MeterRegistry registry, String metricsPrefix) {
        this(testID, interval, sendStatsEnabled, recvStatsEnabled, returnStatsEnabled, confirmStatsEnabled, legacyMetrics, useMillis, csvOut, registry, metricsPrefix, System.out);
    }

    public PrintlnStats(String testID, long interval, boolean sendStatsEnabled, boolean recvStatsEnabled, boolean returnStatsEnabled, boolean confirmStatsEnabled, boolean legacyMetrics, boolean useMillis, PrintWriter csvOut, MeterRegistry registry, String metricsPrefix, PrintStream out) {
        super(interval, useMillis, registry, metricsPrefix);
        this.sendStatsEnabled = sendStatsEnabled;
        this.recvStatsEnabled = recvStatsEnabled;
        this.returnStatsEnabled = returnStatsEnabled;
        this.confirmStatsEnabled = confirmStatsEnabled;
        this.testID = testID;
        this.legacyMetrics = legacyMetrics;
        this.useMillis = useMillis;
        this.units = useMillis ? "ms" : "\u00b5s";
        this.csvOut = csvOut;
        this.out = out;
        if (this.csvOut != null) {
            this.csvOut.printf("id,time (s),published (msg/s),returned (msg/s),confirmed (msg/s),nacked (msg/s),received (msg/s),min consumer latency (%s),median consumer latency (%s),75th p. consumer latency (%s),95th p. consumer latency (%s),99th p. consumer latency (%s),min confirm latency (%s),median confirm latency (%s),75th p. confirm latency (%s),95th p. confirm latency (%s),99th p. confirm latency (%s)%n", this.units, this.units, this.units, this.units, this.units, this.units, this.units, this.units, this.units, this.units);
        }
    }

    private static String formatRate(double rate) {
        if (rate == 0.0) {
            return String.format("%d", (long)rate);
        }
        if (rate < 1.0) {
            return String.format("%1.2f", rate);
        }
        if (rate < 10.0) {
            return String.format("%1.1f", rate);
        }
        return String.format("%d", (long)rate);
    }

    private static String rate(double rate, boolean display) {
        if (display) {
            return PrintlnStats.formatRate(rate);
        }
        return "";
    }

    private static double rate(long count, long elapsed) {
        return 1000.0 * (double)count / (double)elapsed;
    }

    @Override
    protected void report(long now) {
        if (!this.printFinalOnGoingOrDone.get()) {
            this.doReport(now);
        }
    }

    private void doReport(long now) {
        String output = "id: " + this.testID + ", ";
        double ratePublished = 0.0;
        double rateReturned = 0.0;
        double rateConfirmed = 0.0;
        double rateNacked = 0.0;
        double rateConsumed = 0.0;
        if (this.sendStatsEnabled) {
            ratePublished = PrintlnStats.rate(this.sendCountInterval, this.elapsedInterval);
            this.published(ratePublished);
        }
        if (this.sendStatsEnabled && this.returnStatsEnabled) {
            rateReturned = PrintlnStats.rate(this.returnCountInterval, this.elapsedInterval);
            this.returned(rateReturned);
        }
        if (this.sendStatsEnabled && this.confirmStatsEnabled) {
            rateConfirmed = PrintlnStats.rate(this.confirmCountInterval, this.elapsedInterval);
            this.confirmed(rateConfirmed);
        }
        if (this.sendStatsEnabled && this.confirmStatsEnabled) {
            rateNacked = PrintlnStats.rate(this.nackCountInterval, this.elapsedInterval);
            this.nacked(rateNacked);
        }
        if (this.recvStatsEnabled) {
            rateConsumed = PrintlnStats.rate(this.recvCountInterval, this.elapsedInterval);
            this.received(rateConsumed);
        }
        output = output + "time: " + String.format("%.3f", (double)(now - this.startTime) / 1000.0) + "s";
        output = output + this.getRate("sent", ratePublished, this.sendStatsEnabled) + this.getRate("returned", rateReturned, this.sendStatsEnabled && this.returnStatsEnabled) + this.getRate("confirmed", rateConfirmed, this.sendStatsEnabled && this.confirmStatsEnabled) + this.getRate("nacked", rateNacked, this.sendStatsEnabled && this.confirmStatsEnabled) + this.getRate("received", rateConsumed, this.recvStatsEnabled);
        long[] consumerLatencyStats = null;
        long[] confirmLatencyStats = null;
        if (this.legacyMetrics && this.latencyCountInterval > 0) {
            output = output + this.legacyMetrics();
        } else {
            if (this.shouldDisplayConsumerLatency() || this.shouldDisplayConfirmLatency()) {
                output = output + ", min/median/75th/95th/99th ";
            }
            if (this.shouldDisplayConsumerLatency()) {
                output = output + "consumer latency: ";
                consumerLatencyStats = this.getStats(this.latency);
                output = output + consumerLatencyStats[0] + "/" + consumerLatencyStats[1] + "/" + consumerLatencyStats[2] + "/" + consumerLatencyStats[3] + "/" + consumerLatencyStats[4] + " " + this.units;
            }
            if (this.shouldDisplayConsumerLatency() && this.shouldDisplayConfirmLatency()) {
                output = output + ", ";
            }
            if (this.shouldDisplayConfirmLatency()) {
                output = output + "confirm latency: ";
                confirmLatencyStats = this.getStats(this.confirmLatency);
                output = output + confirmLatencyStats[0] + "/" + confirmLatencyStats[1] + "/" + confirmLatencyStats[2] + "/" + confirmLatencyStats[3] + "/" + confirmLatencyStats[4] + " " + this.units;
            }
        }
        if (!this.printFinalOnGoingOrDone.get()) {
            this.out.println(output);
        }
        this.writeToCsvIfNecessary(now, ratePublished, rateReturned, rateConfirmed, rateNacked, rateConsumed, consumerLatencyStats, confirmLatencyStats);
    }

    private String legacyMetrics() {
        return ", min/avg/max latency: " + this.minLatency / 1000L + "/" + this.cumulativeLatencyInterval / (1000L * (long)this.latencyCountInterval) + "/" + this.maxLatency / 1000L + " \u00b5s ";
    }

    private void writeToCsvIfNecessary(long now, double ratePublished, double rateReturned, double rateConfirmed, double rateNacked, double rateConsumed, long[] consumerLatencyStats, long[] confirmLatencyStats) {
        if (this.csvOut != null && !this.printFinalOnGoingOrDone.get()) {
            if (consumerLatencyStats == null) {
                consumerLatencyStats = this.getStats(this.latency);
            }
            if (confirmLatencyStats == null) {
                confirmLatencyStats = this.getStats(this.confirmLatency);
            }
            this.csvOut.println(this.testID + "," + String.format("%.3f", (double)(now - this.startTime) / 1000.0) + "," + PrintlnStats.rate(ratePublished, this.sendStatsEnabled) + "," + PrintlnStats.rate(rateReturned, this.sendStatsEnabled && this.returnStatsEnabled) + "," + PrintlnStats.rate(rateConfirmed, this.sendStatsEnabled && this.confirmStatsEnabled) + "," + PrintlnStats.rate(rateNacked, this.sendStatsEnabled && this.confirmStatsEnabled) + "," + PrintlnStats.rate(rateConsumed, this.recvStatsEnabled) + "," + (this.shouldDisplayConsumerLatency() ? consumerLatencyStats[0] + "," + consumerLatencyStats[1] + "," + consumerLatencyStats[2] + "," + consumerLatencyStats[3] + "," + consumerLatencyStats[4] + "," : ",,,,,") + (this.shouldDisplayConfirmLatency() ? confirmLatencyStats[0] + "," + confirmLatencyStats[1] + "," + confirmLatencyStats[2] + "," + confirmLatencyStats[3] + "," + confirmLatencyStats[4] : ",,,,"));
        }
    }

    boolean shouldDisplayConsumerLatency() {
        return this.recvStatsEnabled;
    }

    boolean shouldDisplayConfirmLatency() {
        return this.sendStatsEnabled && this.confirmStatsEnabled;
    }

    private long[] getStats(Histogram histogram) {
        return new long[]{this.div(histogram.getSnapshot().getMin()), this.div(histogram.getSnapshot().getMedian()), this.div(histogram.getSnapshot().get75thPercentile()), this.div(histogram.getSnapshot().get95thPercentile()), this.div(histogram.getSnapshot().get99thPercentile())};
    }

    private long div(double p) {
        if (this.useMillis) {
            return (long)p;
        }
        return (long)(p / 1000.0);
    }

    private String getRate(String descr, double rate, boolean display) {
        if (display) {
            return ", " + descr + ": " + PrintlnStats.formatRate(rate) + " " + MESSAGE_RATE_LABEL;
        }
        return "";
    }

    public void printFinal() {
        if (this.printFinalOnGoingOrDone.compareAndSet(false, true)) {
            long now = System.currentTimeMillis();
            System.out.println("id: " + this.testID + ", sending rate avg: " + PrintlnStats.formatRate((double)this.sendCountTotal * 1000.0 / (double)(now - this.startTime)) + " " + MESSAGE_RATE_LABEL);
            long elapsed = now - this.startTime;
            if (elapsed > 0L) {
                System.out.println("id: " + this.testID + ", receiving rate avg: " + PrintlnStats.formatRate((double)this.recvCountTotal * 1000.0 / (double)elapsed) + " " + MESSAGE_RATE_LABEL);
            }
        }
    }
}

