/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.impl.DefaultExceptionHandler;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelaxedExceptionHandler
extends DefaultExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelaxedExceptionHandler.class);

    private static boolean isSocketClosedOrConnectionReset(Throwable e) {
        return e instanceof IOException && ("Connection reset".equals(e.getMessage()) || "Socket closed".equals(e.getMessage()) || "Connection reset by peer".equals(e.getMessage())) || e instanceof AlreadyClosedException && e.getMessage() != null && e.getMessage().contains("connection is already closed due to clean connection shutdown");
    }

    protected void log(String message, Throwable e) {
        if (RelaxedExceptionHandler.isSocketClosedOrConnectionReset(e)) {
            LOGGER.info("{} (Exception message: {})", (Object)message, (Object)e.getMessage());
        } else {
            LOGGER.error(message, e);
        }
    }
}

