/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.perf.MulticastParams;
import com.rabbitmq.perf.MulticastVariable;
import com.rabbitmq.perf.PerfUtil;
import com.rabbitmq.perf.RateVsLatencyScenario;
import com.rabbitmq.perf.Scenario;
import com.rabbitmq.perf.SimpleScenario;
import com.rabbitmq.perf.Variable;
import com.rabbitmq.perf.VaryingScenario;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScenarioFactory {
    private static final Map<String, String> JSON_FIELDS_TO_PROPERTY_NAMES = new HashMap<String, String>(){
        {
            this.put("body", "bodyFiles");
            this.put("rate", "producerRateLimit");
            this.put("consumer-rate", "consumerRateLimit");
        }
    };

    public static Scenario fromJSON(Map json, ConnectionFactory factory) {
        String uri = "amqp://localhost";
        String type = ScenarioFactory.read("type", json, String.class);
        String name = ScenarioFactory.read("name", json, String.class);
        Integer interval = ScenarioFactory.read("interval", json, Double.class, 1000.0).intValue();
        List paramsJSON = ScenarioFactory.read("params", json, List.class);
        try {
            uri = ScenarioFactory.read("uri", json, String.class, uri);
            factory.setUri(uri);
        }
        catch (Exception e) {
            throw new RuntimeException("scenario: " + name + " with malformed uri: " + uri + " - " + e.getMessage());
        }
        MulticastParams[] params = new MulticastParams[paramsJSON.size()];
        for (int i = 0; i < paramsJSON.size(); ++i) {
            params[i] = ScenarioFactory.paramsFromJSON((Map)paramsJSON.get(i));
        }
        if (type.equals("simple")) {
            return new SimpleScenario(name, factory, interval.intValue(), params);
        }
        if (type.equals("rate-vs-latency")) {
            return new RateVsLatencyScenario(name, factory, params[0]);
        }
        if (type.equals("varying")) {
            List variablesJSON = ScenarioFactory.read("variables", json, List.class);
            Variable[] variables = new Variable[variablesJSON.size()];
            for (int i = 0; i < variablesJSON.size(); ++i) {
                variables[i] = ScenarioFactory.variableFromJSON((Map)variablesJSON.get(i));
            }
            return new VaryingScenario(name, factory, params, variables);
        }
        throw new RuntimeException("Type " + type + " was not simple or varying.");
    }

    private static <T> T read(String key, Map map, Class<T> clazz) {
        if (map.containsKey(key)) {
            return ScenarioFactory.read0(key, map, clazz);
        }
        throw new RuntimeException("Key " + key + " not found.");
    }

    private static <T> T read(String key, Map map, Class<T> clazz, T def) {
        if (map.containsKey(key)) {
            return ScenarioFactory.read0(key, map, clazz);
        }
        return def;
    }

    private static <T> T read0(String key, Map map, Class<T> clazz) {
        Object o = map.get(key);
        if (clazz.isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        throw new RuntimeException("Object under key " + key + " was a " + o.getClass() + ", not a " + clazz + ".");
    }

    static MulticastParams paramsFromJSON(Map json) {
        MulticastParams params = new MulticastParams();
        params.setAutoDelete(true);
        for (Object key : json.keySet()) {
            PerfUtil.setValue(params, ScenarioFactory.mapJsonFieldToPropertyName((String)key), json.get(key));
        }
        return params;
    }

    static String mapJsonFieldToPropertyName(String jsonField) {
        if (JSON_FIELDS_TO_PROPERTY_NAMES.containsKey(jsonField)) {
            return JSON_FIELDS_TO_PROPERTY_NAMES.get(jsonField);
        }
        return ScenarioFactory.hyphensToCamel(jsonField);
    }

    private static Variable variableFromJSON(Map json) {
        String type = ScenarioFactory.read("type", json, String.class, "multicast");
        String name = ScenarioFactory.read("name", json, String.class);
        Object[] values = ScenarioFactory.read("values", json, List.class).toArray();
        if (type.equals("multicast")) {
            return new MulticastVariable(ScenarioFactory.mapJsonFieldToPropertyName(name), values);
        }
        throw new RuntimeException("Type " + type + " was not multicast");
    }

    private static String hyphensToCamel(String name) {
        String out = "";
        for (String part : name.split("-")) {
            out = out + part.substring(0, 1).toUpperCase() + part.substring(1);
        }
        return out.substring(0, 1).toLowerCase() + out.substring(1);
    }
}

