/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.perf.MulticastParams;
import com.rabbitmq.perf.ScenarioStats;
import com.rabbitmq.perf.Stats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class SimpleScenarioStats
extends Stats
implements ScenarioStats {
    private static final int IGNORE_FIRST = 3;
    private final List<Map<String, Object>> samples = new ArrayList<Map<String, Object>>();
    private long elapsedTotalToIgnore;
    private long minMsgSize;

    public SimpleScenarioStats(long interval) {
        super(interval);
    }

    @Override
    protected void report(long now) {
        if (this.samples.size() == 3) {
            this.cumulativeLatencyTotal = 0L;
            this.latencyCountTotal = 0;
            this.sendCountTotal = 0;
            this.recvCountTotal = 0;
            this.elapsedTotalToIgnore = this.elapsedTotal;
        }
        HashMap<String, Number> sample = new HashMap<String, Number>();
        sample.put("send-msg-rate", this.rate(this.sendCountInterval, this.elapsedInterval));
        sample.put("send-bytes-rate", this.rate(this.sendCountInterval, this.elapsedInterval) * (double)this.minMsgSize);
        sample.put("recv-msg-rate", this.rate(this.recvCountInterval, this.elapsedInterval));
        sample.put("recv-bytes-rate", this.rate(this.recvCountInterval, this.elapsedInterval) * (double)this.minMsgSize);
        sample.put("elapsed", this.elapsedTotal);
        if (this.latencyCountInterval > 0) {
            sample.put("avg-latency", this.intervalAverageLatency());
            sample.put("min-latency", this.minLatency / 1000L);
            sample.put("max-latency", this.maxLatency / 1000L);
        }
        this.samples.add(sample);
    }

    @Override
    public Map<String, Object> results() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("send-msg-rate", this.getSendRate());
        map.put("send-bytes-rate", this.getSendRate() * (double)this.minMsgSize);
        map.put("recv-msg-rate", this.getRecvRate());
        map.put("recv-bytes-rate", this.getRecvRate() * (double)this.minMsgSize);
        if (this.latencyCountTotal > 0) {
            map.put("avg-latency", this.overallAverageLatency());
        }
        map.put("samples", this.samples);
        return map;
    }

    public void setup(MulticastParams params) {
        this.minMsgSize = params.getMinMsgSize();
    }

    public double getSendRate() {
        return this.rate(this.sendCountTotal, this.elapsedTotal - this.elapsedTotalToIgnore);
    }

    public double getRecvRate() {
        return this.rate(this.recvCountTotal, this.elapsedTotal - this.elapsedTotalToIgnore);
    }

    private double rate(long count, long elapsed) {
        return elapsed == 0L ? 0.0 : 1000.0 * (double)count / (double)elapsed;
    }

    private long overallAverageLatency() {
        return this.cumulativeLatencyTotal / (1000L * (long)this.latencyCountTotal);
    }

    private long intervalAverageLatency() {
        return this.cumulativeLatencyInterval / (1000L * (long)this.latencyCountInterval);
    }
}

