/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.perf.FixedValueIndicator;
import com.rabbitmq.perf.MessageBodySource;
import com.rabbitmq.perf.TimestampProvider;
import com.rabbitmq.perf.ValueIndicator;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.function.BiFunction;

public class TimeSequenceMessageBodySource
implements MessageBodySource {
    private static final byte[] EMPTY = new byte[0];
    private final TimestampProvider tsp;
    private final BiFunction<ByteArrayOutputStream, Long, MessageBodySource.MessageEnvelope> messageCreator;

    public TimeSequenceMessageBodySource(TimestampProvider tsp, int minMsgSize) {
        this(tsp, new FixedValueIndicator<Integer>(minMsgSize));
    }

    public TimeSequenceMessageBodySource(TimestampProvider tsp, ValueIndicator<Integer> sizeIndicator) {
        this.tsp = tsp;
        if (sizeIndicator.isVariable()) {
            List<Integer> possibleSizes = sizeIndicator.values();
            byte[][] messages = new byte[possibleSizes.size()][];
            for (int i = 0; i < possibleSizes.size(); ++i) {
                messages[i] = new byte[possibleSizes.get(i).intValue()];
            }
            this.messageCreator = (acc, time) -> {
                byte[] m;
                int size = (Integer)sizeIndicator.getValue();
                byte[] message = EMPTY;
                for (byte[] m2 : messages) {
                    if (m2.length != size) continue;
                    message = m2;
                    break;
                }
                if ((m = acc.toByteArray()).length <= message.length) {
                    System.arraycopy(m, 0, message, 0, m.length);
                    return new MessageBodySource.MessageEnvelope(message, null, (long)time);
                }
                return new MessageBodySource.MessageEnvelope(m, null, (long)time);
            };
        } else {
            byte[] message = new byte[sizeIndicator.getValue().intValue()];
            this.messageCreator = (acc, time) -> {
                byte[] m = acc.toByteArray();
                if (m.length <= message.length) {
                    System.arraycopy(m, 0, message, 0, m.length);
                    return new MessageBodySource.MessageEnvelope(message, null, (long)time);
                }
                return new MessageBodySource.MessageEnvelope(m, null, (long)time);
            };
        }
    }

    @Override
    public MessageBodySource.MessageEnvelope create(int sequenceNumber) throws IOException {
        ByteArrayOutputStream acc = new ByteArrayOutputStream();
        DataOutputStream d = new DataOutputStream(acc);
        long time = this.tsp.getCurrentTime();
        d.writeInt(sequenceNumber);
        d.writeLong(time);
        d.flush();
        acc.flush();
        return this.messageCreator.apply(acc, time);
    }
}

