/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version {
    public static final String VERSION;
    public static final String BUILD;
    public static final String BUILD_TIMESTAMP;
    private static final Logger LOGGER;

    private static String getVersion() {
        String version;
        try {
            version = Version.getValueFromPropertyFile("com.rabbitmq.perf.version");
        }
        catch (Exception e1) {
            LOGGER.warn("Couldn't get version from property file", (Throwable)e1);
            try {
                version = Version.getVersionFromPackage();
            }
            catch (Exception e2) {
                LOGGER.warn("Couldn't get version with Package#getImplementationVersion", (Throwable)e1);
                version = Version.getDefaultVersion();
            }
        }
        return version;
    }

    private static String getBuild() {
        String build;
        try {
            build = Version.getValueFromPropertyFile("com.rabbitmq.perf.build");
        }
        catch (Exception e) {
            LOGGER.warn("Couldn't get build from property file", (Throwable)e);
            build = Version.getDefaultBuild();
        }
        return build;
    }

    private static String getBuildTimestamp() {
        String build;
        try {
            build = Version.getValueFromPropertyFile("com.rabbitmq.perf.build.timestamp");
        }
        catch (Exception e) {
            LOGGER.warn("Couldn't get build timestamp from property file", (Throwable)e);
            build = Version.getDefaultBuildTimestamp();
        }
        return build;
    }

    private static String getValueFromPropertyFile(String key) throws Exception {
        Properties version = new Properties();
        try (InputStream inputStream = Version.class.getClassLoader().getResourceAsStream("rabbitmq-perf-test.properties");){
            version.load(inputStream);
        }
        if (version.getProperty(key) == null) {
            throw new IllegalStateException("Coulnd't find " + key + " property in property file");
        }
        return version.getProperty(key);
    }

    private static String getVersionFromPackage() {
        if (Version.class.getPackage().getImplementationVersion() == null) {
            throw new IllegalStateException("Couldn't get version with Package#getImplementationVersion");
        }
        return Version.class.getPackage().getImplementationVersion();
    }

    private static String getDefaultVersion() {
        return "0.0.0";
    }

    private static String getDefaultBuild() {
        return "unknown";
    }

    private static String getDefaultBuildTimestamp() {
        return "unknown";
    }

    static {
        LOGGER = LoggerFactory.getLogger(Version.class);
        VERSION = Version.getVersion();
        BUILD = Version.getBuild();
        BUILD_TIMESTAMP = Version.getBuildTimestamp();
    }
}

